<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/helpers.php';
ensure_session();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $pass = $_POST['password'] ?? '';
  try {
    register_user($name,$email,$phone,$pass);
    login($email,$pass);
    header("Location: " . base_url('/user/index.php'));
    exit;
  } catch (Throwable $t) {
    $error = 'Kayıt başarısız (e-posta zaten kayıtlı olabilir).';
  }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kayıt Ol</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width:560px;">
  <div class="card bg-white border p-4">
    <h1 class="h5 mb-3">Kayıt Ol</h1>
    <?php if ($error): ?><div class="alert alert-danger"><?= e($error) ?></div><?php endif; ?>
    <form method="post" class="vstack gap-2">
      <input class="form-control" name="name" placeholder="Ad Soyad" required>
      <input class="form-control" name="email" placeholder="E-posta" required>
      <input class="form-control" name="phone" placeholder="Telefon (opsiyon)">
      <input class="form-control" name="password" placeholder="Şifre" type="password" required>
      <button class="btn btn-primary">Kayıt ol</button>
    </form>
    <div class="mt-3"><a href="<?= e(base_url('/user/login.php')) ?>">Giriş yap</a></div>
  </div>
</div>
</body>
</html>
