<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
include __DIR__ . '/_layout/header.php';

$pdo = db();
$cats = $pdo->query("SELECT * FROM categories WHERE is_active=1 ORDER BY sort_order ASC, name ASC")->fetchAll();

$q = trim($_GET['q'] ?? '');
$cat = (int)($_GET['cat'] ?? 0);

$sql = "SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON c.id=p.category_id WHERE p.is_active=1";
$params = [];
if ($q !== '') { $sql .= " AND (p.name LIKE ? OR p.sku LIKE ?)"; $params[]="%$q%"; $params[]="%$q%"; }
if ($cat > 0) { $sql .= " AND p.category_id=?"; $params[]=$cat; }
$sql .= " ORDER BY p.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h5 mb-0">Ürünler</h1>
</div>

<form class="row g-2 mb-3" method="get">
  <div class="col-12 col-md-5">
    <input class="form-control" name="q" placeholder="Ürün adı / kodu ara" value="<?= e($q) ?>">
  </div>
  <div class="col-12 col-md-5">
    <select class="form-select" name="cat">
      <option value="0">Tüm kategoriler</option>
      <?php foreach($cats as $c): ?>
        <option value="<?= (int)$c['id'] ?>" <?= $cat===(int)$c['id']?'selected':'' ?>><?= e($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-12 col-md-2 d-grid">
    <button class="btn btn-primary">Filtrele</button>
  </div>
</form>

<div class="row g-3">
  <?php if (count($products)===0): ?>
    <div class="col-12"><div class="alert alert-warning mb-0">Sonuç bulunamadı.</div></div>
  <?php endif; ?>

  <?php foreach($products as $p): ?>
    <div class="col-12 col-sm-6 col-lg-4">
      <div class="card border bg-white h-100">
        <?php if (!empty($p['cover_image'])): ?>
          <img class="product-cover" src="<?= e(base_url('/uploads/' . $p['cover_image'])) ?>" alt="<?= e($p['name']) ?>">
        <?php else: ?>
          <div class="product-cover d-flex align-items-center justify-content-center text-muted">Görsel yok</div>
        <?php endif; ?>
        <div class="card-body">
          <div class="fw-semibold"><?= e($p['name']) ?></div>
          <div class="text-muted small"><?= e($p['category_name'] ?? '') ?></div>
          <div class="mt-2">
            <?php if (!empty($p['sale_price'])): ?>
              <div class="text-muted small"><s><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</s></div>
              <div class="fs-5 fw-bold"><?= number_format((float)$p['sale_price'], 2, ',', '.') ?> TL</div>
            <?php else: ?>
              <div class="fs-5 fw-bold"><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</div>
            <?php endif; ?>
          </div>
          <div class="d-grid gap-2 mt-3">
            <a class="btn btn-outline-primary btn-sm" href="<?= e(base_url('/public/product.php?slug=' . $p['slug'])) ?>">Detay</a>
            <a class="btn btn-success btn-sm" target="_blank" rel="noopener" href="<?= e(wa_link($p)) ?>">WhatsApp’tan Sipariş</a>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php include __DIR__ . '/_layout/footer.php'; ?>
