<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
include __DIR__ . '/_layout/header.php';

$slug = trim($_GET['slug'] ?? '');
if ($slug === '') { http_response_code(404); echo "Ürün bulunamadı."; exit; }

$pdo = db();
$stmt = $pdo->prepare("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON c.id=p.category_id WHERE p.slug=? AND p.is_active=1 LIMIT 1");
$stmt->execute([$slug]);
$p = $stmt->fetch();

if (!$p) { http_response_code(404); echo "Ürün bulunamadı."; exit; }

$imgs = $pdo->prepare("SELECT * FROM product_images WHERE product_id=? ORDER BY sort_order ASC, id ASC");
$imgs->execute([(int)$p['id']]);
$images = $imgs->fetchAll();

// Lead log (opsiyonel)
try {
  $ins = $pdo->prepare("INSERT INTO leads (product_id,page,ip,user_agent) VALUES (?,?,?,?)");
  $ins->execute([(int)$p['id'],'product',$_SERVER['REMOTE_ADDR'] ?? null, substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 250)]);
} catch (Throwable $t) {}

?>
<div class="row g-4">
  <div class="col-lg-6">
    <div class="card bg-white border p-3">
      <?php if (!empty($p['cover_image'])): ?>
        <img class="w-100 rounded-4" style="max-height:420px;object-fit:cover"
             src="<?= e(base_url('/uploads/' . $p['cover_image'])) ?>" alt="<?= e($p['name']) ?>">
      <?php else: ?>
        <div class="text-muted">Görsel yok</div>
      <?php endif; ?>

      <?php if (count($images) > 0): ?>
        <div class="row g-2 mt-2">
          <?php foreach($images as $im): ?>
            <div class="col-4">
              <img class="w-100 rounded-3" style="height:110px;object-fit:cover"
                   src="<?= e(base_url('/uploads/' . $im['image'])) ?>" alt="">
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="col-lg-6">
    <div class="card bg-white border p-4">
      <div class="text-muted small mb-1"><?= e($p['category_name'] ?? '') ?></div>
      <h1 class="h4 mb-2"><?= e($p['name']) ?></h1>
      <?php if (!empty($p['sku'])): ?>
        <div class="text-muted small mb-3">Ürün Kodu: <span class="fw-semibold"><?= e($p['sku']) ?></span></div>
      <?php endif; ?>

      <div class="mb-3">
        <?php if (!empty($p['sale_price'])): ?>
          <div class="text-muted"><s><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</s></div>
          <div class="display-6 fw-bold"><?= number_format((float)$p['sale_price'], 2, ',', '.') ?> TL</div>
        <?php else: ?>
          <div class="display-6 fw-bold"><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</div>
        <?php endif; ?>
      </div>

      <?php if (!empty($p['short_desc'])): ?>
        <p class="text-muted"><?= e($p['short_desc']) ?></p>
      <?php endif; ?>

      <div class="d-grid gap-2">
        <a class="btn btn-success btn-lg" target="_blank" rel="noopener" href="<?= e(wa_link($p)) ?>">
          WhatsApp’tan Sipariş Ver
        </a>
        <a class="btn btn-outline-secondary" href="<?= e(base_url('/public/products.php')) ?>">Geri</a>
      </div>
    </div>

    <?php if (!empty($p['description'])): ?>
      <div class="card bg-white border p-4 mt-3">
        <h2 class="h6">Açıklama</h2>
        <div class="text-muted"><?= nl2br(e($p['description'])) ?></div>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php include __DIR__ . '/_layout/footer.php'; ?>
