<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
include __DIR__ . '/_layout/header.php';

$pdo = db();
$sliders = $pdo->query("SELECT * FROM sliders WHERE is_active=1 ORDER BY sort_order ASC, id DESC")->fetchAll();
$featured = $pdo->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON c.id=p.category_id WHERE p.is_active=1 AND p.featured=1 ORDER BY p.id DESC LIMIT 8")->fetchAll();
?>
<div class="row g-4">
  <div class="col-12">
    <div class="bg-white border hero-card">
      <?php if (count($sliders) > 0): ?>
      <div class="swiper">
        <div class="swiper-wrapper">
          <?php foreach($sliders as $sli): ?>
            <div class="swiper-slide">
              <img src="<?= e(base_url('/uploads/' . $sli['image'])) ?>" alt="<?= e($sli['title']) ?>">
            </div>
          <?php endforeach; ?>
        </div>
        <div class="swiper-pagination"></div>
        <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div>
      </div>
      <div class="p-4">
        <h1 class="h4 mb-1">Su arıtma sistemlerinde güvenilir çözüm</h1>
        <p class="text-muted mb-0">Ürünlerimizi inceleyin, fiyatı görün, sipariş için WhatsApp’tan yazın.</p>
      </div>
      <?php else: ?>
        <div class="p-4">
          <h1 class="h4 mb-1">cengizsuaritma</h1>
          <p class="text-muted mb-0">Slider görsellerini Admin Panel’den ekleyebilirsin.</p>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="col-12">
    <div class="row g-3">
      <div class="col-md-4">
        <div class="card border bg-white p-3 h-100">
          <div class="fw-semibold">✅ Ücretsiz Bilgilendirme</div>
          <div class="text-muted small mt-1">İhtiyacına uygun sistem önerisi.</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card border bg-white p-3 h-100">
          <div class="fw-semibold">✅ Filtre Değişimi</div>
          <div class="text-muted small mt-1">Periyodik bakım ve filtre değişim hizmeti.</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card border bg-white p-3 h-100">
          <div class="fw-semibold">✅ Garanti & Servis</div>
          <div class="text-muted small mt-1">Kurulum sonrası destek.</div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <div class="d-flex justify-content-between align-items-center">
      <h2 class="h5 mb-0">Öne Çıkan Ürünler</h2>
      <a class="btn btn-outline-primary btn-sm" href="<?= e(base_url('/public/products.php')) ?>">Tüm Ürünler</a>
    </div>
  </div>

  <?php if (count($featured) === 0): ?>
    <div class="col-12">
      <div class="alert alert-info mb-0">Henüz ürün yok. Admin Panel’den ürün ekleyebilirsin.</div>
    </div>
  <?php endif; ?>

  <?php foreach($featured as $p): ?>
    <div class="col-12 col-sm-6 col-lg-3">
      <div class="card border bg-white h-100">
        <?php if (!empty($p['cover_image'])): ?>
          <img class="product-cover" src="<?= e(base_url('/uploads/' . $p['cover_image'])) ?>" alt="<?= e($p['name']) ?>">
        <?php else: ?>
          <div class="product-cover d-flex align-items-center justify-content-center text-muted">Görsel yok</div>
        <?php endif; ?>
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-start gap-2">
            <div>
              <div class="fw-semibold"><?= e($p['name']) ?></div>
              <div class="text-muted small"><?= e($p['category_name'] ?? '') ?></div>
            </div>
            <?php if (!empty($p['sale_price'])): ?>
              <span class="badge badge-soft">İndirim</span>
            <?php endif; ?>
          </div>
          <div class="mt-2">
            <?php if (!empty($p['sale_price'])): ?>
              <div class="text-muted small"><s><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</s></div>
              <div class="fs-5 fw-bold"><?= number_format((float)$p['sale_price'], 2, ',', '.') ?> TL</div>
            <?php else: ?>
              <div class="fs-5 fw-bold"><?= number_format((float)$p['price'], 2, ',', '.') ?> TL</div>
            <?php endif; ?>
          </div>
          <div class="d-grid gap-2 mt-3">
            <a class="btn btn-primary btn-sm" href="<?= e(base_url('/public/product.php?slug=' . $p['slug'])) ?>">İncele</a>
            <a class="btn btn-success btn-sm" target="_blank" rel="noopener" href="<?= e(wa_link($p)) ?>">WhatsApp’tan Sipariş</a>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php include __DIR__ . '/_layout/footer.php'; ?>
