<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/helpers.php';
$s = settings();
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($s['site_name']) ?></title>
  <link rel="icon" href="<?= e(base_url('/public/assets/favicon.svg')) ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
  <link rel="stylesheet" href="<?= e(base_url('/public/assets/site.css')) ?>">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg bg-white border-bottom sticky-top">
  <div class="container">
    <a class="navbar-brand fw-semibold" href="<?= e(base_url('/public/index.php')) ?>"><?= e($s['site_name']) ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="<?= e(base_url('/public/index.php')) ?>">Anasayfa</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(base_url('/public/products.php')) ?>">Ürünler</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(base_url('/public/about.php')) ?>">Hakkımızda</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(base_url('/public/contact.php')) ?>">İletişim</a></li>
        <li class="nav-item ms-lg-2">
          <a class="btn btn-success btn-sm" target="_blank" rel="noopener"
             href="<?= e("https://wa.me/" . preg_replace('~[^0-9]~','',$s['whatsapp_number'])) ?>">
             WhatsApp'tan Yaz
          </a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<div class="container my-4">
