-- cengizsuaritma schema
CREATE TABLE IF NOT EXISTS settings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  site_name VARCHAR(120) NOT NULL DEFAULT 'cengizsuaritma',
  whatsapp_number VARCHAR(32) NOT NULL DEFAULT '905000000000',
  whatsapp_template TEXT NOT NULL DEFAULT 'Merhaba, {urun} ürününü satın almak istiyorum. Fiyat: {fiyat} TL. Ürün kodu: {sku}'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO settings (id, site_name, whatsapp_number, whatsapp_template)
VALUES (1,'cengizsuaritma','905000000000','Merhaba, {urun} ürününü satın almak istiyorum. Fiyat: {fiyat} TL. Ürün kodu: {sku}')
ON DUPLICATE KEY UPDATE site_name=VALUES(site_name);

CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  slug VARCHAR(140) NOT NULL UNIQUE,
  sort_order INT NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  category_id INT NULL,
  name VARCHAR(160) NOT NULL,
  slug VARCHAR(180) NOT NULL UNIQUE,
  sku VARCHAR(80) NOT NULL DEFAULT '',
  price DECIMAL(10,2) NOT NULL DEFAULT 0,
  sale_price DECIMAL(10,2) NULL,
  short_desc VARCHAR(255) NOT NULL DEFAULT '',
  description MEDIUMTEXT NULL,
  featured TINYINT(1) NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  cover_image VARCHAR(255) NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS product_images (
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NOT NULL,
  image VARCHAR(255) NOT NULL,
  sort_order INT NOT NULL DEFAULT 0,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS sliders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(160) NOT NULL,
  subtitle VARCHAR(220) NOT NULL DEFAULT '',
  image VARCHAR(255) NOT NULL,
  button_text VARCHAR(80) NOT NULL DEFAULT 'Detay',
  button_link VARCHAR(255) NOT NULL DEFAULT '#',
  sort_order INT NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(190) NOT NULL UNIQUE,
  phone VARCHAR(40) NULL,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','user') NOT NULL DEFAULT 'user',
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS leads (
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NULL,
  page VARCHAR(120) NULL,
  ip VARCHAR(64) NULL,
  user_agent VARCHAR(255) NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Seed
INSERT INTO categories (name, slug, sort_order, is_active) VALUES
('Tezgah Altı Sistemler','tezgah-alti-sistemler',1,1),
('Filtre & Yedek Parça','filtre-yedek-parca',2,1)
ON DUPLICATE KEY UPDATE name=VALUES(name);

-- default admin
-- password: admin12345
INSERT INTO users (name,email,phone,password_hash,role)
VALUES ('Admin','admin@cengizsuaritma.local',NULL,'$2y$10$WZqN3QhR3j7vWj0/UK7nF.JcY6mFiOAk0cJ8QcmwKqH9Gf2p9oJ0e','admin')
ON DUPLICATE KEY UPDATE role='admin';
