<?php
function db() : PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  $env = require __DIR__ . '/../config/.env.php';
  $db = $env['db'];

  $dsn = "mysql:host={$db['host']};dbname={$db['name']};charset={$db['charset']}";
  $opts = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ];
  $pdo = new PDO($dsn, $db['user'], $db['pass'], $opts);
  return $pdo;
}
