<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
include __DIR__ . '/_layout/admin_header.php';

$pdo = db();
$counts = [
  'products' => (int)$pdo->query("SELECT COUNT(*) c FROM products")->fetch()['c'],
  'sliders' => (int)$pdo->query("SELECT COUNT(*) c FROM sliders")->fetch()['c'],
  'leads' => (int)$pdo->query("SELECT COUNT(*) c FROM leads")->fetch()['c'],
];
$last = $pdo->query("SELECT l.created_at, p.name FROM leads l LEFT JOIN products p ON p.id=l.product_id ORDER BY l.id DESC LIMIT 8")->fetchAll();
?>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card bg-white border p-3">
      <div class="text-muted small">Ürün</div>
      <div class="fs-3 fw-bold"><?= $counts['products'] ?></div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card bg-white border p-3">
      <div class="text-muted small">Slider</div>
      <div class="fs-3 fw-bold"><?= $counts['sliders'] ?></div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card bg-white border p-3">
      <div class="text-muted small">Lead</div>
      <div class="fs-3 fw-bold"><?= $counts['leads'] ?></div>
    </div>
  </div>
</div>

<div class="card bg-white border p-3 mt-3">
  <div class="fw-semibold mb-2">Son Lead Kayıtları (Ürün detay görüntülenince)</div>
  <div class="table-responsive">
    <table class="table table-sm align-middle mb-0">
      <thead><tr><th>Tarih</th><th>Ürün</th></tr></thead>
      <tbody>
        <?php foreach($last as $r): ?>
          <tr><td class="text-muted small"><?= e($r['created_at']) ?></td><td><?= e($r['name'] ?? '-') ?></td></tr>
        <?php endforeach; ?>
        <?php if (count($last)===0): ?>
          <tr><td colspan="2" class="text-muted">Kayıt yok.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/_layout/admin_footer.php'; ?>
